<?php
/**
 * @version		$Id: authordetails.php 3 2008-07-07 22:00:38Z pentacle $
 * @package		Author Details
 * @copyright	(C) 2008 Ercan Ozkaya. All rights reserved.
 * @license		GNU/GPL 2.0
 * @author		Ercan Ozkaya <ozkayaercan@gmail.com>
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgContentAuthordetails extends JPlugin
{
	var $layouts;

	function plgContentAuthorDetails( &$subject, $params )
	{
		parent::__construct( $subject, $params );
		$this->layouts = JPATH_SITE.DS.'plugins'.DS.'content'.DS.'authordetails'.DS.'layouts'.DS;
	}

	function onAfterDisplayContent(&$article, &$params, $limitstart)
	{
		if (JRequest::getCmd('view', '') != 'article') {
			return '';
		}

		if (($this->params->get('showuncat', 0) == 0) && ($article->sectionid == 0) && ($article->catid == 0)) {
			return '';
		}

		if (($params->get('show_author', 1) != 1) && ($this->params->get('obeyauthor', 1) == 1)) {
			return '';
		}

		$showInformation = $this->params->get('showinformation', 1);
		$showArticles	 = $this->params->get('showarticles', 1);

		if (!$showArticles && !$showInformation) {
			return '';
		}

		if ($allowedArticles = trim($this->params->get('allowedarticles', ''))) {
			$articleids = explode(',', $allowedArticles);
			JArrayHelper::toInteger($articleids);
			if (!in_array($article->id, $articleids)) {
				return '';
			}
		}

		if ($allowedCategories = trim($this->params->get('allowedcategories', ''))) {
			$catids = explode(',', $allowedCategories);
			JArrayHelper::toInteger($catids);
			if (!in_array($article->catid, $catids)) {
				return '';
			}
		}

		if ($allowedSections = trim($this->params->get('allowedsections', ''))) {
			$secids = explode(',', $allowedSections);
			JArrayHelper::toInteger($secids);
			if (!in_array($article->sectionid, $secids)) {
				return '';
			}
		}

		$output = '';

		//$this->loadLanguage('plg_content_authordetails_frontend' , JPATH_ADMINISTRATOR );

		if ($showInformation) {
			$iLayout = trim($this->params->get('information_layout', 'information_default')).'.php';
			$output .= $this->_displayInformation($article, $iLayout);
		}

		if ($showArticles) {
			$aLayout = trim($this->params->get('articles_layout', 'articles_default')).'.php';
			$output .= $this->_displayArticles($article, $aLayout);
		}

		if(!empty($output)) {
			$output = '<div class="authordetails">' . $output . '</div>';
		}
		return $output;
	}

	function _buildQuery(&$article)
	{
		$user =& JFactory::getUser();
		$db =& JFactory::getDBO();
		$date =& JFactory::getDate();

		// Categories
		if ($articleCats = $this->params->get('articlecats', '')) {
			$ids = explode(',', $articleCats);
			JArrayHelper::toInteger($ids);
			$catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $ids ) . ')';
		}

		// Sections
		if ($articleSecs = $this->params->get('articlesecs', '')) {
			$ids = explode(',', $articleSecs);
			JArrayHelper::toInteger($ids);
			$secCondition = ' AND (s.id=' . implode( ' OR s.id=', $ids ) . ')';
		}

		if (!empty($article->created_by_alias) && ($this->params->get('obeyalias', 1) == 1)) {
			$createdBy = ' AND (a.created_by_alias = ' . $db->Quote(trim($article->created_by_alias)) . ')';
		} else {
			$createdBy = ' AND (a.created_by = ' . (int) $article->created_by . ')'
					. ' AND (a.created_by_alias = \'\')';
		}

		$aid = $user->get('aid', 0);
		$contentConfig = &JComponentHelper::getParams('com_content');
		$access	= !$contentConfig->get('shownoauth');
		$nullDate = $db->getNullDate();
		$now = $date->toMySQL();

		$query = 'SELECT a.*, ' .
			' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
			' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug'.
			' FROM #__content AS a' .
			' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
			' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
			' WHERE a.state = 1 AND s.id > 0' .
			' AND a.id <> ' . (int) $article->id .
			' AND (a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).')' .
			' AND (a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).')' .
			$createdBy .
			($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
			($articleCats ? $catCondition : '').
			($articleSecs ? $secCondition : '').
			' AND s.published = 1' .
			' AND cc.published = 1' .
			' ORDER BY ' . (($this->params->get('ordering', 'newest') == 'newest') ? 'a.created DESC' : 'RAND()');
		return $query;
	}

	function _displayInformation(&$article, $layout)
	{
		ob_start();
		require($this->layouts . $layout);
		$return = ob_get_clean();
		return $return;
	}

	function _displayArticles(&$article, $layout)
	{
		$db =& JFactory::getDBO();
		$query = $this->_buildQuery($article);
		$db->setQuery($query, 0, (int) $this->params->get('count', 5));
		$rows = $db->loadObjectList();
		if (count($rows) == 0) {
			return '';
		}
		require_once(JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');

		$titleLength = (int) $this->params->get('titlelength', 40);
		$links = array();
		$return = '';

		for ($i = 0, $n = count($rows); $i < $n; $i++) {
			$links[$i] = new stdClass();
			$links[$i]->href = JRoute::_(ContentHelperRoute::getArticleRoute($rows[$i]->slug, $rows[$i]->catslug, $rows[$i]->sectionid));
			if (!empty($titleLength) && ($titleLength < JString::strlen($rows[$i]->title))) {
				$links[$i]->title = htmlspecialchars(JString::substr($rows[$i]->title, 0, $titleLength - 3) . '...');
			} else {
				$links[$i]->title = htmlspecialchars($rows[$i]->title);
			}
			$links[$i]->date = JHTML::_('date', $rows[$i]->created, JText::_('DATE_FORMAT_LC3'));
		}

		ob_start();
		require($this->layouts . $layout);
		$return = ob_get_clean();

		return $return;
	}
}