/* adapted for 3.9+ - global ajaxurl, attachMediaBoxL10n */

var findPosts;
( function( $ ){
	findPosts = {
		open: function( af_name, af_val ) {
			var overlay = $( '.ui-find-overlay' );

			if ( overlay.length === 0 ) {
				$( 'body' ).append( '<div class="ui-find-overlay"></div>' );
				findPosts.overlay();
			}

			overlay.show();

			if ( af_name && af_val ) {
				$( '#affected' ).attr( 'name', af_name ).val( af_val );
			}

			$( '#find-posts' ).show();

			$('#find-posts-input').focus().keyup( function( event ){
				if ( event.which == 27 ) {
					findPosts.close();
				} // close on Escape
			});

			// Pull some results up by default
			findPosts.send();

			return false;
		},

		close: function() {
			$('#find-posts-response').html('');
			$('#find-posts').hide();
			$( '.ui-find-overlay' ).hide();
		},

		overlay: function() {
			$( '.ui-find-overlay' ).on( 'click', function () {
				findPosts.close();
			});
		},

		choose : function() { // xili
			lang = $('#affected').val();
			linked = $('input[name="found_post_id"]:checked').val();
			$('#xili_language_lang-'+lang).val( linked );
			$('#find-posts-response').html('');
			$('#find-posts').hide();
			$( '.ui-find-overlay' ).hide(); // same in close to avoid resave post - only fill

		},

		send: function() {

			var post = {
					ps: $( '#find-posts-input' ).val(),
					action: 'find_post_types',
					_ajax_nonce: $('#_ajax_nonce').val()
				};
			var selectedItem;
			spinner = $( '.find-box-search .spinner' );

			spinner.show();
			post['post_type'] = $('#find-posts-what').val(); //selectedItem;

			$.ajax( ajaxurl, {
				type: 'POST',
				data: post,
				dataType: 'json'
			}).always( function() {
				spinner.hide();
			}).done( function( x ) {
				if ( ! x.success ) {
					$( '#find-posts-response' ).text( attachMediaBoxL10n.error );
				}

				$( '#find-posts-response' ).html( x.data );
			}).fail( function() {
				$( '#find-posts-response' ).text( attachMediaBoxL10n.error );
			});
		}
	};

	$( document ).ready( function() {
		$( '#find-posts-submit' ).click( function( event ) {
			if ( ! $( '#find-posts-response input[type="radio"]:checked' ).length ) {
				event.preventDefault();
			}
		    // no resave only fill input...
		    event.preventDefault();
			findPosts.choose();	 // xili
		});
		$( '#find-posts .find-box-search :input' ).keypress( function( event ) {
			if ( 13 == event.which ) {
				findPosts.send();
				return false;
			}
		});
		$( '#find-posts-search' ).click( findPosts.send );
		$( '#find-posts-close' ).click( findPosts.close );
		$( '#doaction, #doaction2' ).click( function( event ) {
			$( 'select[name^="action"]' ).each( function() {
				if ( $(this).val() === 'attach' ) {
					event.preventDefault();
					findPosts.open();
				}
			});
		});

		// Enable whole row to be clicked
		$( '.find-box-inside' ).on( 'click', 'tr', function() {
			$( this ).find( '.found-radio input' ).prop( 'checked', true );
		});
	});
})( jQuery );
