<!DOCTYPE html>
<?php $mts_options = get_option(MTS_THEME_NAME); ?>
<html class="no-js" <?php language_attributes(); ?>>
<head itemscope itemtype="http://schema.org/WebSite">
	<meta charset="<?php bloginfo('charset'); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<?php mts_meta(); ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body id="blog" <?php body_class('main'); ?> itemscope itemtype="http://schema.org/WebPage">       
	<div class="main-container">
		<header class="main-header" role="banner" itemscope itemtype="http://schema.org/WPHeader">
			<div id="header">
				<div class="container">
					<div class="logo-wrap">
						<?php if ($mts_options['mts_logo'] != '') { ?>
							<?php if( is_front_page() || is_home() || is_404() ) { ?>
								<h1 id="logo" class="image-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_attr( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"<?php if (!empty($mts_options['mts_logo2x'])) { echo ' data-at2x="'.esc_attr( $mts_options['mts_logo2x'] ).'"'; } ?>></a>
								</h1><!-- END #logo -->
							<?php } else { ?>
								<h2 id="logo" class="image-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_attr( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"<?php if (!empty($mts_options['mts_logo2x'])) { echo ' data-at2x="'.esc_attr( $mts_options['mts_logo2x'] ).'"'; } ?>></a>
								</h2><!-- END #logo -->
							<?php } ?>
						<?php } else { ?>
							<?php if( is_front_page() || is_home() || is_404() ) { ?>
								<h1 id="logo" class="text-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
								</h1><!-- END #logo -->
							<?php } else { ?>
								<h2 id="logo" class="text-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
								</h2><!-- END #logo -->
							<?php } ?>
							
						<?php } ?>
					</div>
					<?php if (!empty($mts_options['mts_header_social'])) { ?>
						<div class="header-social">   
							<?php if ( !empty($mts_options['mts_header_social']) && is_array($mts_options['mts_header_social'])) { ?>
								<?php foreach( $mts_options['mts_header_social'] as $header_icons ) : ?>
							        <?php if( ! empty( $header_icons['mts_header_icon'] ) && isset( $header_icons['mts_header_icon'] ) ) : ?>
							            <a href="<?php echo esc_url( $header_icons['mts_header_icon_link'] ); ?>" class="header-<?php echo $header_icons['mts_header_icon'] ?>"><span class="fa fa-<?php echo $header_icons['mts_header_icon'] ?>"></span></a>
							        <?php endif; ?>
							    <?php endforeach; ?>
							<?php } ?>
               			</div> <!--social-icons-->
               		<?php } ?>
					
					<?php if (!empty($mts_options['mts_header_search'])) { ?>
	        	    	<div class="search-style-one">
	                    	<a id="trigger-overlay">
	                        	<i class="fa fa-search"></i>
	                    	</a>
	                    	<div class="overlay overlay-slideleft">
	                        	<div class="container">
	                            	<div class="search-row">
	                            	<button type="button" class="overlay-close">×</button>
										<?php get_search_form(); ?>
	                            	</div>
	                        	</div>  
	                    	</div>
	                	</div>
                	<?php } ?>
					<?php if ( $mts_options['mts_show_primary_nav'] == '1' ) { ?>
			    		<div class="primary-navigation" role="navigation">
					 		<a href="#" id="pull" class="toggle-mobile-menu"><?php _e('Menu', 'mythemeshop'); ?></a>
							<nav id="navigation" class="mobile-menu-wrapper clearfix" itemscope itemtype="http://schema.org/SiteNavigationElement">
								<?php if ( has_nav_menu( 'primary-menu' ) ) { ?>
									<?php wp_nav_menu( array( 'theme_location' => 'primary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
								<?php } else { ?>
									<ul class="menu clearfix">
										<?php wp_list_pages('title_li='); ?>
									</ul>
								<?php } ?>
							</nav>
			     		</div>
					<?php } ?>   
				</div><!--#header-->
			</div><!--.container-->
		</header>