<?php $mts_options = get_option(MTS_THEME_NAME); ?>
<?php $sidebar_type = isset( $mts_options['mts_sidebar_layout'] ) ? $mts_options['mts_sidebar_layout'] : '0' ?>
<?php $latest_posts_class = ( '0' === $sidebar_type ) ? 'latest-posts-full-width' : 'latest-posts-left'; ?>
<?php get_header(); ?>
<?php if ( !is_paged() && is_front_page() && $mts_options['mts_featured_slider'] == '1' ) { ?>
    <div class="full-slider-container clearfix loading">
        <div class="container">
            <div id="slider" class="full-slider">
                <?php if ( empty( $mts_options['mts_featured_slider_cat'] ) || !is_array( $mts_options['mts_featured_slider_cat'] ) ) {
                    $mts_options['mts_featured_slider_cat'] = array('0');
                }
                $slider_cat = implode( ",", $mts_options['mts_featured_slider_cat'] );
                $slider_query = new WP_Query('cat='.$slider_cat.'&posts_per_page='.$mts_options['mts_featured_slider_num']);
                $i = 1;
                while ( $slider_query->have_posts() ) : $slider_query->the_post(); ?>
                    <div class="slider-item" <?php if ( $i % 2 !== 0 ) { echo 'data-merge="2"'; };?>> 
                        <a href="<?php echo esc_url( get_the_permalink() ); ?>">
                            <?php if ( $i % 2 !== 0 ) { ?>
                                <?php the_post_thumbnail('slider1',array('title' => '')); ?>
                            <?php } else {
                                the_post_thumbnail('slider2',array('title' => ''));
                            } $i++; ?>
                            <div class="slide-caption">
                                <h2 class="slide-title"><?php the_title(); ?></h2>
                                <?php mts_the_postinfo('slider'); ?>
                            </div>
                        </a> 
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>
            </div>
        </div>
        <div class="owl-controls"></div>
    </div>
<?php } ?>
<div id="page">
    <div class="<?php mts_article_class(); ?>">
        <div id="content_box">
            <?php if ( !is_paged() ) { ?>
                <?php $featured_categories = array();
                if ( !empty( $mts_options['mts_featured_categories'] ) ) {
                    $number=1;
                    foreach ( $mts_options['mts_featured_categories'] as $section ) {
                        $category_id = $section['mts_featured_category'];
                        $featured_categories[] = $category_id;
                        $posts_num = $section['mts_featured_category_postsnum'];
                        if ( 'latest' == $category_id ) {
                            $j = 0;
                            echo '<div class="latest-posts '.$latest_posts_class.'">';
                            if ( have_posts() ) : while ( have_posts() ) : the_post();
                                if ( $number ==3 && '0' === $sidebar_type ) { 
                                    get_sidebar( 'home' );
                                } ?>    
                                <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>" itemscope itemtype="http://schema.org/BlogPosting">
                                    <?php mts_archive_post(); ?>
                                </article>
                                <?php
                                $number++;
                            endwhile; endif;

                            if ( $j !== 0 ) { // No pagination if there is no posts
                                mts_pagination();
                            }
                            echo '</div>';
                            if ( '0' !== $sidebar_type ) get_sidebar( 'home' );
                        } else { ?>
                            <div class="featured-category">
                                <h3 class="featured-category-title"><a href="<?php echo esc_url( get_category_link( $category_id ) ); ?>" title="<?php echo esc_attr( get_cat_name( $category_id ) ); ?>"><?php echo esc_html( get_cat_name( $category_id ) ); ?></a></h3>
                                <?php
                                $j = 0; $cat_query = new WP_Query('cat='.$category_id.'&posts_per_page='.$posts_num);
                                if ( $cat_query->have_posts() ) : while ( $cat_query->have_posts() ) : $cat_query->the_post();
                                ?>   
                                    <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>" itemscope itemtype="http://schema.org/BlogPosting">
                                        <?php mts_archive_post(); ?>
                                    </article>
                                    <?php $number++;
                                endwhile; endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                            <?php
                        }
                    }
                }
            } else { //Paged
                echo '<div class="latest-posts '.$latest_posts_class.'">';
                $numbers=1;
                $j = 0;
                if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                    <?php if ( $numbers ==3  && '0' === $sidebar_type ) {
                        get_sidebar( 'home' );
                    } ?>
                    <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>" itemscope itemtype="http://schema.org/BlogPosting">
                        <?php mts_archive_post(); ?>
                    </article>
                    <?php $numbers++;
                endwhile; endif; ?>
                <?php if ( $j !== 0 ) { // No pagination if there is no posts
                    mts_pagination();
                }
                echo '</div>';
                if ( '0' !== $sidebar_type ) get_sidebar( 'home' );
            } ?>
        </div>
    </div>
<?php get_footer(); ?>